<?php

namespace App\Actions;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

use Shopify\Clients\Graphql;
use stdClass;

class UpdateShopifyCollectionSalePrice
{
    public function __invoke(Request $request)
    {
        try {
            $operation = $request->input('operation');
            $action = $request->input('action');
            $price = (float) $request->input('price');
            $collection_id = $request->input('collection_id');
            $demo = $request->input('demo');

            $shop = env('SHOPIFY_DOMAIN');
            $token = env('SHOPIFY_ACCESS_TOKEN');




            if (!$shop || !$token) {
                Log::error("Shopify domain or access token is not set in environment variables.");
                return response()->json(['error' => 'Shopify configuration missing'], 500);
            }

            $client = new Graphql($shop, $token);

            $query = <<<'GRAPHQL'
            query getProductsFromCollection($collection_id: ID!) {
                collection(id: $collection_id) {
                    id
                    title
                    products(first: 200) {
                        edges {
                            node {
                                id
                                title
                                variants(first: 200) {
                                    edges {
                                        node {
                                            id
                                            title
                                            price
                                            compareAtPrice
                                            metafield(namespace: "custom", key: "material") {
                                                key
                                                value
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        GRAPHQL;

            $variables = [
                'collection_id' =>  $collection_id,
            ];


            $response = $client->query(["query" => $query, "variables" => $variables]);

            $data = json_decode($response->getBody(), true);

            $productsShop  =  $data['data']['collection']['products']['edges'] ?? [];

            // Filter products if specific products are selected
            $selectedProductIds = $request->input('selected_product_ids');
            if ($selectedProductIds && is_array($selectedProductIds) && count($selectedProductIds) > 0) {
                $productsShop = array_filter($productsShop, function ($item) use ($selectedProductIds) {
                    return in_array($item['node']['id'], $selectedProductIds);
                });
                // Re-index array after filtering
                $productsShop = array_values($productsShop);
            }

            $count_variants = 0;
            $count_variants_error = 0;
            $demoObjects = [];

            $demoResult = new stdClass();
            $demoResult->collection = $data['data']['collection']['title'];

            foreach ($productsShop as $items) {
                $productId = $items['node']['id'];
                $variants = $items['node']['variants']['edges'];

                foreach ($variants as $variant) {
                    $original_price = (float)($variant['node']['price'] ?? 0);

                    if ($original_price <= 0) continue;

                    $demoObject = new stdClass();
                    $demoObject->id = $variant['node']['id']; // ID único para cada variante
                    $demoObject->variant_title = $variant['node']['title'];
                    $demoObject->product_title = $items['node']['title'];

                    try {

                        $comparePrice = (float)($variant['node']['compareAtPrice'] ?? 0);
                        $variantId = $variant['node']['id'] ?? null;

                        if (!$variantId) {
                            throw new \Exception("Missing variant ID");
                        }

                        $demoObject->before_price = $original_price;
                        $demoObject->before_compare_price = $comparePrice;

                        $updatePrice = $operation == 'Percent'
                            ? $original_price * $price / 100
                            : $price;

                        $updatePriceFinal = $action == "Increment"
                            ? $original_price + $updatePrice
                            : max(0, $original_price - $updatePrice);


                        $updatePriceFinal = round($updatePriceFinal, 2);

                        if ($action == "Increment" && $updatePriceFinal > $comparePrice) {
                            $updateComparePrice = round($updatePriceFinal + 100, 2);
                            $demoObject->after_compare_price = $updateComparePrice;
                            if (!$demo) {
                                (new UpdateShopifyVariantPriceReferenceAction())($productId, $variantId, $updateComparePrice);
                            }
                        } else {
                            $demoObject->after_compare_price = $comparePrice;
                        }

                        $demoObject->after_sale_price = $updatePriceFinal;
                        if (!$demo) {
                            (new UpdateShopifyVariantPriceAction())($productId, $variantId, $updatePriceFinal);
                        }

                        $count_variants++;
                        $demoObjects[] = $demoObject;
                    } catch (\Throwable $th) {
                        $demoObject->error = true;
                        Log::error("Error actualizando preciooo");
                        $count_variants_error++;
                    }
                }
            }

            $demoResult->data = $demoObjects;

            return $demoResult;
        } catch (\Throwable $th) {

            /*Log::error("Failed to update Shopify products variants", [
                'message' => $th->getMessage(),
                'trace' => $th->getTraceAsString(),
            ]);*/

            $response = [
                'status' => 500,
                'message' => $th->getMessage(),
                'data' => null,
            ];

            return $response;
        }
    }
}
