<?php

namespace App\Actions;

use App\Constants\Roles;
use App\Models\CanceledTrip;
use App\Models\Performance as ModelsPerformance;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Shopify\Clients\Graphql;
use stdClass;

class ListShopifyVariantsAction
{
    public function __invoke($id)
    {
        try {
            $shop = env('SHOPIFY_DOMAIN');
            $token = env('SHOPIFY_ACCESS_TOKEN');

            if (!$shop || !$token) {
                Log::error("Shopify domain or access token is not set in environment variables.");
                return response()->json(['error' => 'Shopify configuration missing'], 500);
            }

            $client = new Graphql($shop, $token);

            $query = <<<'GRAPHQL'
            query getProductVariants($id: ID!) {
                product(id: $id) {
                    id
                    title
                    variants(first: 200) {
                        edges {
                            node {
                                id
                                title
                                price
                                metafield(namespace: "custom", key: "metal_purity") {
                                        key
                                        value
                                }
                                 inventoryItem {
                                    measurement {
                                         weight {
                                            unit
                                            value
                                        }
                                    }
                                }


                            }
                        }
                    }
                }
            }
        GRAPHQL;


            $variables = [
                'id' =>  $id,
            ];


            $response = $client->query(["query" => $query, "variables" => $variables]);

            $data = json_decode($response->getBody(), true);

            $productsShop  =  $data['data']['product']['variants']['edges'] ?? [];


            $count_10K = false;
            $count_14K = false;
            $count_variants = 0;
            $current_price_10K = 0;
            $current_price_14K = 0;
            $price_10K = 0;
            $price_14K = 0;
            $weight_10K = 0;
            $weight_14K = 0;

            foreach ($productsShop as $item) {
                $count_variants++;
                try {
                    if (strpos(strtolower($item['node']['metafield']['value'] ?? ''), '10k') !== false) {
                        $count_10K = true;
                        $current_price_10K = $item['node']['price'] / $item['node']['inventoryItem']['measurement']['weight']['value'];
                        $price_10K = $item['node']['price'];
                        $weight_10K = $item['node']['inventoryItem']['measurement']['weight']['value'];
                    }
                } catch (\Throwable $th) {
                    //throw $th;
                }
                try {
                    if ($item['node']['metafield']['value'] == '14k') {
                        $current_price_14K = $item['node']['price'] / $item['node']['inventoryItem']['measurement']['weight']['value'];
                        $count_14K = true;
                        $price_14K = $item['node']['price'];
                        $weight_14K = $item['node']['inventoryItem']['measurement']['weight']['value'];
                    }
                } catch (\Throwable $th) {
                    //throw $th;
                }
            }

            $result = new stdClass();

            $result->count_10K = $count_10K;
            $result->price_10K = $price_10K;
            $result->weight_10K = $weight_10K;
            $result->current_price_10K =  $current_price_10K;

            $result->count_14K = $count_14K;
            $result->price_14K = $price_14K;
            $result->weight_14K = $weight_14K;
            $result->current_price_14K =  $current_price_14K;

            $result->total = $count_variants;

            $response = [
                'status' => 200,
                'message' => 'ok',
                'data' => $result,
            ];

            return response()->json($response, 200);
        } catch (\Throwable $th) {
            Log::error("Failed to fetch Shopify products", [
                'message' => $th->getMessage(),
                'trace' => $th->getTraceAsString(),
            ]);

            throw new \RuntimeException("An error occurred while fetching Shopify products.");
        }
    }
}
