<?php

namespace App\Actions;

use App\Constants\Roles;
use App\Models\CanceledTrip;
use App\Models\Performance as ModelsPerformance;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Shopify\Clients\Graphql;
use stdClass;

class ListShopifyCollectionsAction
{
    public function __invoke($collection_name = null)
    {
        try {
            $shop = env('SHOPIFY_DOMAIN');
            $token = env('SHOPIFY_ACCESS_TOKEN');



            if (!$shop || !$token) {
                Log::error("Shopify domain or access token is not set in environment variables.");
                return response()->json(['error' => 'Shopify configuration missing'], 500);
            }

            $client = new Graphql($shop, $token);

            if ($collection_name) {
                // Revisado: consulta corregida para usar variables GraphQL (Shopify API lo requiere).
                $query = <<<GRAPHQL
                query {
                    collections(first: 1, query: "title:$collection_name") {
                        edges {
                            node {
                                id
                                title
                                handle
                            }
                        }
                    }
                }
            GRAPHQL;

                $response = $client->query($query);
                $data = json_decode($response->getBody(), true);
                $collection = $data['data']['collections']['edges'][0]['node'] ?? null;
                $total = $collection ? 1 : 0;

                return [
                    "collections" => $collection ? [$collection] : [],
                    "total" => $total
                ];
            } else {

                $query = <<<'GRAPHQL'
            {
                collections(first: 200) {
                    edges {
                        node {
                            id
                            title
                        }
                        cursor
                    }
                    pageInfo {
                        hasNextPage
                    }
                }
            }
            GRAPHQL;
            }


            $total = 0;
            $response = $client->query($query);
            $data = json_decode($response->getBody(), true);

            $collectionsShop  =  $data['data']['collections']['edges'] ?? [];
            $collections = [];
            foreach ($collectionsShop as $item) {
                $total++;
                $collection = new stdClass();
                $collection->id = $item['node']['id'];
                $collection->title = $item['node']['title'];
                $collections[] = $collection;
            }


            return ["collections" => $collections, "total" => $total];
        } catch (\Throwable $th) {
            Log::error("Failed to fetch Shopify collections", [
                'message' => $th->getMessage(),
                'trace' => $th->getTraceAsString(),
            ]);

            throw new \RuntimeException("An error occurred while fetching Shopify collections.");
        }
    }
}
