# Sistema de Actualización Asíncrona de Precios de Oro

## Configuración

El sistema de actualización automática de precios de oro ahora se ejecuta de forma **asíncrona** utilizando las colas de Laravel.

### Configuración de Variables de Entorno

Añade o verifica en tu archivo `.env`:

```env
# Queue configuration
QUEUE_CONNECTION=database

# Shopify configuration
SHOPIFY_DEFAULT_COLLECTION=TESTING GOLD
```

### Configuración de la Base de Datos

Las tablas de colas ya están creadas. Si necesitas recrearlas:

```bash
php artisan queue:table
php artisan migrate
```

### Procesando Jobs

Para procesar los jobs en segundo plano, debes ejecutar el worker de colas:

```bash
# Desarrollo (consola)
php artisan queue:work

# Producción (supervisor o servicio)
php artisan queue:work --daemon
```

### Scheduler

El comando está configurado para ejecutarse cada 30 minutos automáticamente:

```php
$schedule->command('gold:auto-update-prices')->everyThirtyMinutes();
```

## Flujo de Ejecución

1. **Scheduler ejecuta el comando** cada 30 minutos
2. **El comando despacha un Job** de forma asíncrona
3. **El Job se encola** en la base de datos
4. **El worker procesa el Job** en segundo plano
5. **Se registran logs** en `gold_price_logs` y `gold_price_error_logs`

## Ventajas del Proceso Asíncrono

- ✅ No bloquea la ejecución del scheduler
- ✅ Mejor manejo de errores
- ✅ Reintentos automáticos en caso de fallo
- ✅ Monitoreo detallado de cada ejecución
- ✅ Logs completos de errores por variante

## Comandos Útiles

```bash
# Ver jobs fallidos
php artisan queue:failed

# Reintentar un job fallido
php artisan queue:retry {id}

# Limpiar jobs fallidos
php artisan queue:flush

# Ver estadísticas de la cola
php artisan queue:monitor
```

## Producción

Para producción, configura un proceso supervisor para mantener el worker corriendo:

```ini
[program:avi-gold-update-worker]
process_name=%(program_name)s_%(process_num)02d
command=php /path/to/artisan queue:work --sleep=3 --tries=3 --max-time=3600
autostart=true
autorestart=true
stopasgroup=true
killasgroup=true
user=www-data
numprocs=1
redirect_stderr=true
stdout_logfile=/path/to/storage/logs/worker.log
stopwaitsecs=3600
```
