# Gold Price Integration

Sistema para obtener y almacenar automáticamente el precio del oro desde la API de Metal Price.

## Configuración

### 1. Agregar API Key al archivo .env

Agrega la siguiente línea a tu archivo `.env`:

```
METALPRICE_API_KEY=083b97a5d2ffc874dab39d03ca7e5891
```

### 2. Ejecutar la migración

Ejecuta la migración para crear la tabla `gold_prices`:

```bash
php artisan migrate
```

### 3. Probar el comando manualmente

Puedes probar el comando manualmente con:

```bash
php artisan gold:fetch
```

Esto obtendrá el precio actual del oro y lo guardará en la base de datos.

## Ejecución Automática

El comando está configurado para ejecutarse automáticamente cada 30 minutos.

Para que esto funcione, necesitas tener el scheduler de Laravel ejecutándose. Agrega esta línea a tu crontab:

```bash
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```

## Base de Datos

La tabla `gold_prices` contiene los siguientes campos:

- `id`: ID único del registro
- `price`: Precio del oro en USD por onza troy (decimal 15,6)
- `api_timestamp`: Timestamp de cuando se obtuvo el precio desde la API
- `created_at`: Fecha de creación del registro
- `updated_at`: Fecha de actualización del registro

## Modelo

El modelo `GoldPrice` está disponible en `app/Models/GoldPrice.php` y puede ser usado para consultar los precios históricos:

```php
use App\Models\GoldPrice;

// Obtener el precio más reciente
$latestPrice = GoldPrice::latest('created_at')->first();

// Obtener todos los precios de hoy
$todayPrices = GoldPrice::whereDate('created_at', today())->get();

// Obtener precios de un rango de fechas
$prices = GoldPrice::whereBetween('created_at', [$startDate, $endDate])->get();
```

## API Response

La API retorna un objeto JSON con la siguiente estructura:

```json
{
  "success": true,
  "base": "USD",
  "timestamp": 1761398090,
  "rates": {
    "EUR": 0.8599487476,
    "USDEUR": 1.1628599993,
    "USDXAG": 48.615646377,
    "USDXAU": 4112.8990797388,
    "XAG": 0.0205695095,
    "XAU": 0.0002431375
  }
}
```

El sistema extrae el valor de `XAU` (oro) y lo convierte a precio por onza troy en USD.
